/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_1074;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Identifiers;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.overlay.DisplayHelper;

public class HealthElement
extends Element {
    public static final class_2960 HEART = new class_2960("hud/heart/full");
    public static final class_2960 HALF_HEART = new class_2960("hud/heart/half");
    public static final class_2960 EMPTY_HEART = new class_2960("hud/heart/container");
    private final float maxHealth;
    private final float health;
    private final String text;

    public HealthElement(float maxHealth, float health) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
            maxHealth = class_3532.method_15386((float)maxHealth);
            health = class_3532.method_15386((float)health);
        }
        this.maxHealth = maxHealth;
        this.health = health;
        this.text = String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
    }

    @Override
    public class_241 getSize() {
        if (this.maxHealth > (float)PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(9 + font.method_1727(this.text)), 10.0f);
        }
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        float maxHealth = this.maxHealth * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new class_241((float)(9 * heartsPerLine), (float)(10 * lineCount));
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        float maxHearts = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_ICONS_PER_LINE);
        int maxHeartsForRender = PluginConfig.INSTANCE.getInt(Identifiers.MC_ENTITY_HEALTH_MAX_FOR_RENDER);
        boolean showNumbers = this.maxHealth > (float)maxHeartsForRender;
        int heartCount = showNumbers ? 1 : class_3532.method_15386((float)(this.maxHealth * 0.5f));
        float health = showNumbers ? 1.0f : this.health * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(this.maxHealth));
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            helper.blitSprite(guiGraphics, EMPTY_HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            if (i <= class_3532.method_15375((float)health)) {
                helper.blitSprite(guiGraphics, HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                helper.blitSprite(guiGraphics, HALF_HEART, (int)(x + (float)xOffset), (int)y, 9, 9);
            }
            xOffset += 9;
            if (showNumbers || i % heartsPerLine != 0) continue;
            y += 10.0f;
            xOffset = 0;
        }
        if (showNumbers) {
            helper.drawText(guiGraphics, this.text, x + 8.0f, y, IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    @Nullable
    public String getMessage() {
        return class_1074.method_4662((String)"narration.jade.health", (Object[])new Object[]{DisplayHelper.dfCommas.format(this.health)});
    }
}

