/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.theme.ThemeCodecs;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.JsonConfig;

public class ThemeHelper
extends class_4309
implements IThemeHelper {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    public static final class_2960 ID = new class_2960("jade", "themes");
    private static final Int2ObjectMap<class_2583> styleCache = new Int2ObjectOpenHashMap(6);
    private final Map<class_2960, Theme> themes = Maps.newTreeMap(Comparator.comparing(class_2960::toString));
    private final class_2096.class_2100 allowedVersions = class_2096.class_2100.method_35287((int)100, (int)199);
    private final class_2583[] modNameStyleCache = new class_2583[3];
    private Theme fallback;

    public ThemeHelper() {
        super(JsonConfig.DEFAULT_GSON, "jade_themes");
    }

    public static class_2583 colorStyle(int color) {
        return (class_2583)styleCache.computeIfAbsent(color, arg_0 -> ((class_2583)class_2583.field_24360).method_36139(arg_0));
    }

    @Override
    public Theme theme() {
        return (Theme)OverlayRenderer.theme.getValue();
    }

    @Override
    public Collection<Theme> getThemes() {
        return this.themes.values();
    }

    @Override
    @NotNull
    public Theme getTheme(class_2960 id) {
        return Objects.requireNonNull(this.themes.getOrDefault(id, this.fallback));
    }

    @Override
    public class_5250 info(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().info());
    }

    @Override
    public class_5250 success(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().success());
    }

    @Override
    public class_5250 warning(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().warning());
    }

    @Override
    public class_5250 danger(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().danger());
    }

    @Override
    public class_5250 failure(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().failure());
    }

    @Override
    public class_5250 title(Object componentOrString) {
        class_5250 component = componentOrString instanceof class_5250 ? (class_5250)componentOrString : class_2561.method_43470((String)Objects.toString(componentOrString));
        return this.color(DisplayHelper.INSTANCE.stripColor((class_2561)component), this.theme().text.colors().title());
    }

    @Override
    public class_5250 modName(Object componentOrString) {
        class_5250 component = componentOrString instanceof class_5250 ? (class_5250)componentOrString : class_2561.method_43470((String)Objects.toString(componentOrString));
        class_2583 itemStyle = IWailaConfig.get().getFormatting().getItemModNameStyle();
        class_2583 themeStyle = this.theme().text.modNameStyle();
        if (this.modNameStyleCache[0] != itemStyle || this.modNameStyleCache[1] != themeStyle) {
            class_2583 style = itemStyle;
            if (themeStyle != null) {
                style = themeStyle.method_27702(style);
            }
            this.modNameStyleCache[0] = itemStyle;
            this.modNameStyleCache[1] = themeStyle;
            this.modNameStyleCache[2] = style;
        }
        return component.method_27696(this.modNameStyleCache[2]);
    }

    @Override
    public class_5250 seconds(int ticks) {
        if ((ticks /= 20) >= 60) {
            int minutes = ticks / 60;
            if ((ticks %= 60) == 0) {
                return this.info(JadeClient.format("jade.minutes", minutes));
            }
            return this.info(JadeClient.format("jade.minutes_seconds", minutes, ticks));
        }
        return this.info(JadeClient.format("jade.seconds", ticks));
    }

    protected class_5250 color(Object componentOrString, int color) {
        if (componentOrString instanceof class_5250) {
            class_5250 component = (class_5250)componentOrString;
            if (component.method_10866().method_10967()) {
                return component.method_10862(ThemeHelper.colorStyle(color));
            }
            return component.method_10862(component.method_10866().method_36139(color));
        }
        return class_2561.method_43470((String)Objects.toString(componentOrString)).method_10862(ThemeHelper.colorStyle(color));
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        Set<class_2960> existingKeys = Set.copyOf(this.themes.keySet());
        MutableObject enable = new MutableObject();
        WailaConfig.ConfigOverlay config = Jade.CONFIG.get().getOverlay();
        this.themes.clear();
        map.forEach((id, json) -> {
            JsonObject o = json.getAsJsonObject();
            int version = class_3518.method_15282((JsonObject)o, (String)"version", (int)0);
            if (!this.allowedVersions.method_9054(version)) {
                Jade.LOGGER.warn("Theme {} has unsupported version {}. Skipping.", id, (Object)version);
                return;
            }
            try {
                ThemeCodecs.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)o).resultOrPartial(arg_0 -> ((Logger)Jade.LOGGER).error(arg_0)).ifPresent(theme -> {
                    theme.id = id;
                    this.themes.put((class_2960)id, (Theme)theme);
                    if (enable.getValue() == null && class_3518.method_15258((JsonObject)o, (String)"autoEnable", (boolean)false) && !existingKeys.contains(id)) {
                        enable.setValue(theme);
                    }
                });
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to load theme {}", id, (Object)e);
            }
        });
        this.fallback = this.themes.get(Theme.DEFAULT_THEME_ID);
        if (this.fallback == null) {
            class_128 crashreport = class_128.method_560((Throwable)new NullPointerException(), (String)"Missing default theme");
            throw new class_148(crashreport);
        }
        int hash = 0;
        for (class_2960 id2 : this.themes.keySet()) {
            hash = 31 * hash + id2.hashCode();
        }
        if (hash != config.themesHash) {
            if (hash != 0 && enable.getValue() != null) {
                Theme theme = (Theme)enable.getValue();
                config.activeTheme = theme.id;
                Jade.LOGGER.info("Auto enabled theme {}", (Object)theme.id);
                if (theme.changeRoundCorner != null) {
                    config.setSquare(theme.changeRoundCorner);
                }
                if (theme.changeOpacity != 0.0f) {
                    config.setAlpha(theme.changeOpacity);
                }
            }
            config.themesHash = hash;
            Jade.CONFIG.save();
        }
        config.applyTheme(config.activeTheme);
    }
}

