/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    private final ConfigGeneral general = new ConfigGeneral();
    private final ConfigOverlay overlay = new ConfigOverlay();
    private final ConfigFormatting formatting = new ConfigFormatting();

    @Override
    public ConfigGeneral getGeneral() {
        return this.general;
    }

    @Override
    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public IPluginConfig getPlugin() {
        return PluginConfig.INSTANCE;
    }

    public static class ConfigGeneral
    implements IWailaConfig.IConfigGeneral {
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList((Object[])new String[]{"emi"});
        public boolean hintOverlayToggle = true;
        public boolean hintNarratorToggle = true;
        public boolean previewOverlay = true;
        private boolean displayTooltip = true;
        private boolean displayBlocks = true;
        private boolean displayEntities = true;
        private boolean displayBosses = true;
        private IWailaConfig.DisplayMode displayMode = IWailaConfig.DisplayMode.TOGGLE;
        private boolean hideFromDebug = true;
        private boolean hideFromTabList = true;
        private boolean enableTextToSpeech = false;
        private IWailaConfig.TTSMode ttsMode = IWailaConfig.TTSMode.PRESS;
        private IWailaConfig.FluidMode fluidMode = IWailaConfig.FluidMode.ANY;
        private float reachDistance = 0.0f;
        @Expose
        private boolean debug = false;
        private boolean itemModNameTooltip = true;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode = IWailaConfig.BossBarOverlapMode.PUSH_DOWN;
        private boolean builtinCamouflage = true;

        public static void init() {
            List<String> names = itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map(ModIdentification::getModName).map(Optional::orElseThrow).toList();
            itemModNameTooltipDisabledByMods.clear();
            itemModNameTooltipDisabledByMods.addAll(names);
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        @Override
        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getReachDistance() {
            return this.reachDistance;
        }

        @Override
        public void setReachDistance(float reachDistance) {
            this.reachDistance = class_3532.method_15363((float)reachDistance, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByMods.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.hideFromTabList = hideFromTabList;
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.hideFromTabList;
        }

        @Override
        public boolean getDisplayBosses() {
            return this.displayBosses;
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.displayBosses = displayBosses;
        }

        @Override
        public boolean getBuiltinCamouflage() {
            return this.builtinCamouflage;
        }

        @Override
        public void setBuiltinCamouflage(boolean builtinCamouflage) {
            this.builtinCamouflage = builtinCamouflage;
        }
    }

    public static class ConfigOverlay
    implements IWailaConfig.IConfigOverlay {
        public class_2960 activeTheme = Theme.DEFAULT_THEME_ID;
        public int themesHash;
        private float overlayPosX = 0.5f;
        private float overlayPosY = 1.0f;
        private float overlayScale = 1.0f;
        private float overlayAnchorX = 0.5f;
        private float overlayAnchorY = 0.0f;
        private boolean overlaySquare = false;
        private boolean flipMainHand = false;
        @Expose
        private float autoScaleThreshold = 0.4f;
        private float alpha = 0.7f;
        private transient Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode = IWailaConfig.IconMode.TOP;
        private boolean animation = true;
        private float disappearingDelay;

        @Override
        public float getOverlayPosX() {
            return class_3532.method_15363((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = class_3532.method_15363((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return class_3532.method_15363((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = class_3532.method_15363((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = class_3532.method_15363((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return class_3532.method_15363((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = class_3532.method_15363((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return class_3532.method_15363((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = class_3532.method_15363((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (this.flipMainHand && class_310.method_1551().field_1690.method_42552().method_41753() == class_1306.field_6182) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public boolean getSquare() {
            return this.overlaySquare;
        }

        @Override
        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        public void applyTheme(class_2960 id) {
            this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            this.activeTheme = this.activeThemeInstance.id;
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }
    }

    public static class ConfigFormatting
    implements IWailaConfig.IConfigFormatting {
        private class_2583 itemModNameStyle = class_2583.field_24360.method_27705(new class_124[]{class_124.field_1078, class_124.field_1056});

        @Override
        public class_2583 getItemModNameStyle() {
            return this.itemModNameStyle;
        }

        @Override
        public void setItemModNameStyle(class_2583 itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public class_2561 registryName(String name) {
            return class_2561.method_43470((String)name).method_27692(IThemeHelper.get().isLightColorScheme() ? class_124.field_1063 : class_124.field_1080);
        }
    }
}

