/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import io.github.reserveword.imblocker.FabricCommon;
import io.github.reserveword.imblocker.FabricConfig;
import io.github.reserveword.imblocker.common.Config;
import io.github.reserveword.imblocker.rules.AxiomGuiRule;
import io.github.reserveword.imblocker.rules.Rules;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

@Environment(value=EnvType.CLIENT)
public class IMBlockerFabric
implements ClientModInitializer {
    public void onInitializeClient() {
        if (this.hasMod("cloth-config") && this.hasMod("modmenu")) {
            AutoConfig.register(FabricConfig.class, GsonConfigSerializer::new);
            Config.INSTANCE = (Config)AutoConfig.getConfigHolder(FabricConfig.class).getConfig();
        } else {
            Config.INSTANCE = new Config(){

                @Override
                public boolean inScreenWhitelist(Class<?> cls) {
                    if (cls == null) {
                        return false;
                    }
                    return FabricCommon.defaultScreenWhitelist.contains(cls.getName());
                }
            };
        }
        ClientTickEvents.START_CLIENT_TICK.register(tick -> Rules.apply());
        Rules.register(new AxiomGuiRule());
    }

    private boolean hasMod(String modid) {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            if (!modid.equals(mod.getMetadata().getId())) continue;
            return true;
        }
        return false;
    }
}

